#include "main.h"

volatile int counter;

void update_counter()
{
  counter++;
}
END_OF_FUNCTION(update_counter)

int level, score, highscore;
BITMAP *back_buffer;

BITMAP *banana, *title, *insanity, *health, *ship, *shot[2], *enemy1[2],
			 *eshot1[2], *cow, *targeting, *shotplus, *shotminus, *enemy2[2],
			 *enemy3[2];
SAMPLE *sthud, *sweird, *sboing, *sfire, *shurt, *sgonenuts, *sow,
			 *ssmallboom, *smoo, *scrazylaugh;

int menu();
int dead();
extern int logic();

short init_everything();

int main()
{
  short gamestatus;
  bool draw;
	highscore = 0;
	
	if (init_everything() == 1)
	{
	  return 1;
	}
	
	clear_to_color(back_buffer, makecol(0, 0, 0));
	particles.clear();
	counter = 0;
	
  gamestatus = MENU;
  draw = false;
  
  while (gamestatus != QUIT)
  {
    while (counter > 0)
    {
      buffer_clear_to_color(BLACK);
      switch (gamestatus)
      {
				case MENU:
					gamestatus = menu();
					break;
				case LOGIC:
					gamestatus = logic();
					break;
				case DEAD:
					gamestatus = dead();
					break;
      }
      draw = true;
      counter--;
    }
    
    if (draw)
    {
      draw_all();
			blit(back_buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
			if (key[KEY_F12])
			{
				save_bitmap("screenshot.bmp", back_buffer, NULL);
			}
      draw = false;
    }
    
		while (counter < 1)
		{
			rest(1);
		}
  }

  destroy_bitmap(back_buffer);
	destroy_bitmap(banana);
	destroy_bitmap(title);
	destroy_bitmap(insanity);
	destroy_bitmap(health);
	destroy_bitmap(ship);
	destroy_bitmap(shot[0]);
	destroy_bitmap(shot[1]);
	destroy_bitmap(enemy1[0]);
	destroy_bitmap(enemy1[1]);
	destroy_bitmap(eshot1[0]);
	destroy_bitmap(eshot1[1]);
	destroy_bitmap(cow);
	destroy_bitmap(targeting);
	destroy_bitmap(shotplus);
	destroy_bitmap(shotminus);
	destroy_bitmap(enemy2[0]);
	destroy_bitmap(enemy2[1]);
	destroy_bitmap(enemy3[0]);
	destroy_bitmap(enemy3[1]);
	destroy_sample(sthud);
	destroy_sample(sweird);
	destroy_sample(sboing);
	destroy_sample(sfire);
	destroy_sample(shurt);
	destroy_sample(sgonenuts);
	destroy_sample(sow);
	destroy_sample(ssmallboom);
	destroy_sample(smoo);
  
  allegro_exit();
  return 0;
}
END_OF_MAIN()

short init_everything()
{
  allegro_init();
  install_keyboard();
  install_timer();
	install_mouse();
	
	srand(time(NULL));
  
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(update_counter);
  
  set_color_depth(16);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
  {
    allegro_message("Couldn't set up a graphics mode!");
    return 1;
  }
  
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  
  install_int_ex(update_counter, BPS_TO_TIMER(50));
  
	back_buffer = create_bitmap(640, 480);

	banana = load_bitmap("media/banana.bmp", NULL);
	title = load_bitmap("media/title.bmp", NULL);
	insanity = load_bitmap("media/insanity.bmp", NULL);
	health = load_bitmap("media/health.bmp", NULL);
	ship = load_bitmap("media/ship.bmp", NULL);
	shot[CRAZY] = load_bitmap("media/crazy/shot.bmp", NULL);
	shot[SANE] = load_bitmap("media/sane/shot.bmp", NULL);
	enemy1[CRAZY] = load_bitmap("media/crazy/enemy1.bmp", NULL);
	enemy1[SANE] = load_bitmap("media/sane/enemy1.bmp", NULL);
	eshot1[CRAZY] = load_bitmap("media/crazy/eshot1.bmp", NULL);
	eshot1[SANE] = load_bitmap("media/sane/eshot1.bmp", NULL);
	cow = load_bitmap("media/crazy/cow.bmp", NULL);
	targeting = load_bitmap("media/targeting.bmp", NULL);
	shotplus = load_bitmap("media/shotplus.bmp", NULL);
	shotminus = load_bitmap("media/shotminus.bmp", NULL);
	enemy2[CRAZY] = load_bitmap("media/crazy/enemy2.bmp", NULL);
	enemy2[SANE] = load_bitmap("media/sane/enemy2.bmp", NULL);
	enemy3[CRAZY] = load_bitmap("media/crazy/enemy3.bmp", NULL);
	enemy3[SANE] = load_bitmap("media/sane/enemy3.bmp", NULL);
	sthud = load_sample("media/sound/thud.wav");
	sweird = load_sample("media/sound/main.wav");
	sboing = load_sample("media/sound/boing.wav");
	sfire = load_sample("media/sound/fire.wav");
	shurt = load_sample("media/sound/ow.wav");
	sgonenuts = load_sample("media/sound/yell.wav");
	sow = load_sample("media/sound/shortow.wav");
	ssmallboom = load_sample("media/sound/boom.wav");
	smoo = load_sample("media/sound/cows.wav");
	scrazylaugh = load_sample("media/sound/crazylaugh.wav");
  
  return 0;
}

int menu()
{
	static short sel = 0, delay = 0;
	static int rotate = rand()%256;
	static int rotate2 = rand()%256;
	char c[20];
	
	new_particle(P_STAR, rand()%640, 0, 0, 1 + float(rand()%100) / 10.0);
	
	buffer_draw_sprite(title, 120, 40);
	buffer_textout_centre_ex(font, "One Player Game", 320, 250, WHITE);
	buffer_textout_centre_ex(font, "Two Player Game", 320, 280, WHITE);
	buffer_textout_centre_ex(font, "Exit", 320, 310, WHITE);

	do_particles();
	
	rotate += rand()%10 + 1;
	if (rotate > 256) rotate = 0;
	rotate2 += rand()%10 + 1;
	if (rotate2 > 256) rotate2 = 0;
	
	buffer_rotate_sprite(banana, 220, 245 + (sel * 30), itofix(rotate));
	buffer_rotate_sprite(banana, 400, 245 + (sel * 30), itofix(rotate2));
	
	sprintf(c, "High Score: %d", highscore);
	buffer_textout_centre_ex(font, c, 320, 450, WHITE);
		
	if (delay <= 0)
	{
		if (key[KEY_UP])
		{
			sel--;
			if (sel < 0) sel = 2;
			delay = 10;
			play_sample(sthud, 255, 128, 1000, 0);
		}
		if (key[KEY_DOWN])
		{
			sel++;
			if (sel > 2) sel = 0;
			delay = 10;
			play_sample(sthud, 255, 128, 1000, 0);
		}
		if (key[KEY_ENTER])
		{
			particles.clear();
			delay = 15;
			score = 0;
			level = 1;
			switch(sel)
			{
				case 0:
					player.init(false);
					return LOGIC;
					break;
				case 1:
					player.init(true);
					return LOGIC;
					break;
				case 2:
					return QUIT;
					break;
			}
		}
		if (key[KEY_ESC])
		{
			return QUIT;
		}
	}
	else
	{
		delay--;
	}
	
	return MENU;
}


int dead()
{
	static bool first = true;
	static int time = 0;
	
	if (first)
	{
		time = 0;
		player.insane = false;
		first = false;
		stop_sample(sweird);
	}
	
	time++;
	if (time < 150)
	{
		new_particle(P_EXPLODE, int(player.x) + rand()%20, int(player.y) + rand()%20, 0, 0);
		if (time % 5 == 0)
		{
			play_sample(ssmallboom, 255, 128, 1500, 0);
		}
		player.draw();
		do_particles();
	}
	else
	{
		buffer_textout_centre_ex(font, "Game Over", 320, 200, WHITE);
		if ((key[KEY_ENTER]) || (key[KEY_ESC]))
		{
			particles.clear();
			first = true;
			return MENU;
		}
	}
	return DEAD;
}
